program p_5_1;

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////}
uses crt, graf_fx;

{// M O J E   T Y P Y   D A N Y C H
{///////////////////////////////////////}

type naglowek_pliku_BMP = record
                           typ_obrazu : array[0..1] of char;
                           rozmiar_pliku : longint;
                           zarezerwowane1 : word;
                           zarezerwowane2 : word;
                           odleglosc_do_obrazu : longint;
                           rozmiar_naglowka_info : longint;
                           szerokosc_obrazu : longint;
                           wysokosc_obrazu : longint;
                           liczba_planow_obrazu : word;
                           liczba_bitow_na_piksel : word;
                           typ_kompresji : longint;
                           rozmiar_obrazu : longint;
                           pozioma_rozdziel_DPI : longint;
                           pionowa_rozdziel_DPI : longint;
                           liczba_uzywanych_kolorow : longint;
                           liczba_znaczacych_kolorow : longint;
                          end;

type wzorzec_koloru_BMP = record
                           niebieski : byte;
                           zielony : byte;
                           czerwony : byte;
                           zarezerwowany : byte;
                          end;

{// Z M I E N N E   G L O B A L N E
{///////////////////////////////////////}
var
plik : file;
licznik, wynik : word;
licznik_petli : word;
naglowek : naglowek_pliku_BMP;
paleta_k : array[0..255] of wzorzec_koloru_BMP;


{// G L O W N Y   P R O G R A M
{///////////////////////////////////////}

begin
{wyczyszczenie erkanu}
clrscr;

{skojarzenie zbioru danych formula1.bmp ze zmienna plikowa plik}
assign(plik, 'formula1.bmp');

{otwarcie pliku i ustlenie liczby odczytywanych bajtow w jednym cyklu odczytu na 1}
reset(plik,1);

{ustalenie liczby cykli odczytu danych}
licznik := sizeof(naglowek_pliku_BMP);

{odczytanie pol naglowkow}
blockread(plik,naglowek, licznik, wynik);

{wypisanie wlasciwowasci pliku i obrazu BMP}
writeln('Typ obrazu : ', naglowek.typ_obrazu[0], naglowek.typ_obrazu[1]);
writeln('Rozmiar pliku : ', naglowek.rozmiar_pliku);
writeln('Zarezerwowane1 : ', naglowek.zarezerwowane1);
writeln('Zarezerwowane2 : ', naglowek.zarezerwowane2);
writeln('Odleglosc do obrazu : ',naglowek.odleglosc_do_obrazu);
writeln('Rozmiar naglowka info. : ', naglowek.rozmiar_naglowka_info);
writeln('Szerokosc obrazu : ', naglowek.szerokosc_obrazu);
writeln('Wysokosc obrazu : ', naglowek.wysokosc_obrazu);
writeln('Liczba planow obrazu : ', naglowek.liczba_planow_obrazu);
writeln('Liczba bitow na piksel : ', naglowek.liczba_bitow_na_piksel);
writeln('Typ kompresji : ', naglowek.typ_kompresji);
writeln('Rozmiar obrazu : ', naglowek.rozmiar_obrazu);
writeln('Pozioma rozdziel. DPI : ', naglowek.pozioma_rozdziel_DPI);
writeln('Pionowa rozdziel. DPI : ', naglowek.pionowa_rozdziel_DPI);
writeln('Uzywanych kolorow : ', naglowek.liczba_uzywanych_kolorow);
writeln('Znaczacych kolorow : ', naglowek.liczba_znaczacych_kolorow);
writeln('');
writeln('Wcisnij dowolny klawisz aby kontynuowac');

{czekanie na dowolny klawisz}
readkey;

{ustalenie liczby cykli odczytu danych}
licznik := sizeof(paleta_k);

{odczytanie palety kolorow}
blockread(plik, paleta_k, licznik, wynik);

{ustawienie trybu graficznego 13h}
g_ustaw_tryb_VGA($13);

{zaladowanie odczytanej palety kolorow do palety karty graficznej}
port[$3c8] := 0; {zaczynamy zapis palety kolorow od pierwszego jej wzorca}

for licznik_petli := 0 to 255 do {zapis w petli wszytkich 255 wzorcow}
begin
port[$3c9] := paleta_k[licznik_petli].czerwony shr 2;
port[$3c9] := paleta_k[licznik_petli].zielony shr 2;
port[$3c9] := paleta_k[licznik_petli].niebieski shr 2;
end; {koniec petli for}

{ustalenie liczby cykli odczytu danych}
licznik := 320;

{odczyt danych obrazu}
for licznik_petli := 0 to 199 do
blockread(plik, mem[$A000:(199 - licznik_petli)*320], licznik, wynik);

{zamkniecie pliku}
close(plik);

{czekanie na dowolny klawisz}
readkey;

end. {koniec programu}